import { View, Text, Pressable, StyleSheet } from "react-native";
import React from "react";
import { orderHistoryStyle } from "../../OrderHistory/OrderHistoryStyle";
import { useNavigation } from "@react-navigation/native";
import usePreferences from "../../../../hooks/usePreferences";
import DotIcon from "../../../../assets/svgs/order history/dot.svg";
import dpr from "../../../Utilities/CustomStyleAttribute/dpr";
import { myReviresStyle } from "../../MyReviews/MyReviewsStyle";
import useProcessPrice from "../../../../hooks/useProcessPrice";
import useLangTranslation from "../../../../hooks/useLangTranslation";
import CustomSVG from "../../../../src/components/CustomSVG/CustomSVG";
const dotSize = dpr(6);

const SingleRefundList = ({ item }) => {
    const { trans } = useLangTranslation();
    const navigation = useNavigation();

    const {
        preference: { default_timezone } = {},
        company: { company_phone } = {},
    } = usePreferences();
    const processPrice = useProcessPrice();

    return (
        <Pressable
            style={orderHistoryStyle.item}
            onPress={() =>
                navigation.navigate("refund details", {
                    refundId: item?.id,
                    timeZone: default_timezone,
                    contact_number: company_phone,
                })
            }
        >
            <View style={orderHistoryStyle.header}>
                <Text style={orderHistoryStyle.headerText}>
                    {item?.order_reference}
                </Text>
                <View
                    style={[
                        refundListStyle.status,
                        refundListStyle.bg(item.status)
                    ]}
                >
                    <CustomSVG svgIcon={DotIcon}
                        height={dotSize}
                        width={dotSize}
                        fill={dynamicStatusDot(item?.status)}
                    />
                    <Text
                        style={[
                            refundListStyle.statusText,
                            refundListStyle.color(item?.status)
                        ]}
                    >
                        {trans(item?.status)}
                    </Text>
                </View>
            </View>
            <View style={myReviresStyle.detailsCont}>
                <View style={orderHistoryStyle.info}>
                    <View style={orderHistoryStyle.infoTextCont}>
                        <CustomSVG svgIcon={DotIcon}
                            height={dotSize}
                            width={dotSize}
                            fill={"#C4C4C4"}
                        />
                        <Text style={orderHistoryStyle.infoText}>
                            {item?.created_at}
                        </Text>
                    </View>
                    <View style={orderHistoryStyle.infoTextCont}>
                        <CustomSVG svgIcon={DotIcon}
                            height={dotSize}
                            width={dotSize}
                            fill={"#C4C4C4"}
                        />
                        <Text style={orderHistoryStyle.infoText}>
                            {trans(item?.status)}
                        </Text>
                    </View>
                </View>
                <Text style={refundListStyle.price}>
                    {processPrice(item?.line_items?.price)}
                </Text>
            </View>
        </Pressable>
    );
};

export default SingleRefundList;

const refundListStyle = StyleSheet.create({
    status: {
        paddingHorizontal: dpr(13),
        paddingVertical: dpr(4),
        borderRadius: 2,
        flexDirection: "row",
        alignItems: "center",
    },
    bg: (status) => ({
        backgroundColor: dynamicStatusBG(status),
    }),
    statusText: {
        marginLeft: dpr(5),
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(10),
        color: "#898989",
    },
    color: (status) => ({
        color: dynamicStatusDot(status),
    }),
    price: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(13),
        color: "#2C2C2C",
    },
});

const dynamicStatusBG = (status) => {
    let color;
    switch (status) {
        case "In progress":
            color = "#FEF8E7";
            break;
        case "Opened":
            color = "#F4F4F4";
            break;
        case "Accepted":
            color = "#EBF9F1";
            break;
        case "Declined":
            color = "#F9E8E8";
            break;
        default:
            color = "#FFFFFF";
            break;
    }
    return color;
};

const dynamicStatusDot = (status) => {
    let color;
    switch (status) {
        case "In progress":
            color = "#DEA512";
            break;
        case "Opened":
            color = "#898989";
            break;
        case "Accepted":
            color = "#009651";
            break;
        case "Declined":
            color = "#C8191C";
            break;
        default:
            color = "#000000";
            break;
    }
    return color;
};
